VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "DCatalog"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = True
Attribute VB_Ext_KEY = "RVB_UniqueId" ,"33EA34E9020E"
'
Option Base 0
Option Explicit
Implements ObjectControl

Private oDb As ADODB.Connection
Private oRs As ADODB.Recordset

'##ModelId=33E103B101E3
Private oObjectContext As ObjectContext

Private Function ObjectControl_CanBePooled() As Boolean
    ObjectControl_CanBePooled = True
End Function

Private Sub ObjectControl_Deactivate()
    Set oObjectContext = Nothing
    Set oDb = Nothing
    Set oRs = Nothing
End Sub

Private Sub ObjectControl_Activate()
    On Error GoTo OCActivateErr
   
    Set oObjectContext = GetObjectContext()
        
    Exit Sub

OCActivateErr:
    Call RaiseError("OCActivate")

End Sub


Public Function GetCatalogItemsByTypes(ByVal vTypeCodes As Variant) As Variant
    On Error GoTo GetCatalogItemsByTypesErr

    Dim vResponse As New Collection
    Dim vItems As New Collection
    Dim vSql As Variant
    Dim vCode As Variant
    Dim vName As Variant
    Dim vPrice As Variant
    Dim vType As Variant
    Dim vCatalogId As Variant
    Dim vDescription As Variant
    Dim vImageURL As Variant
    Dim vPromotionCode As Variant
    Dim vPromotionEndDate As Variant
    Dim vPublicationDate As Variant
    Dim vIdx As Variant
    Dim vTypeCodesLen As Variant
    Dim iStartPos As Integer
    Dim iCommaPos As Integer
    Dim vID As Variant
    Dim bOr As Boolean
    
    
    Let vSql = "SELECT DISTINCTROW Catalog.*, Promotion.PromotionCode, Promotion.PromotionEndDate FROM (Catalog INNER JOIN Categories ON Catalog.CatalogId = Categories.CatalogID) LEFT JOIN Promotion ON Catalog.CatalogId = Promotion.CatalogID WHERE"
    vTypeCodesLen = Len(vTypeCodes)
    
    If vTypeCodesLen > 0 Then
        iStartPos = 1
        Do
            iCommaPos = InStr(iStartPos, vTypeCodes, ",")
            If iCommaPos = 0 Then
                vID = Mid(vTypeCodes, iStartPos, vTypeCodesLen)
                bOr = False
            Else
                vID = Mid(vTypeCodes, iStartPos, iCommaPos - iStartPos)
                bOr = True
            End If
            iStartPos = iCommaPos + 1
            vSql = vSql & "(Categories.CategoryID = '" & vID & "')"
            If bOr Then vSql = vSql & " OR "
        Loop Until iCommaPos = 0
        
        vSql = vSql & " ORDER BY PublicationDate DESC"
          
        Trace (vSql)
          
        Set oDb = oObjectContext.CreateInstance("ADODB.Connection")
        oDb.Open vDbConn
        Set oRs = oDb.Execute(vSql)
        
        While Not oRs.EOF
            Dim CatalogItem As New Collection
        
            vCode = oRs.Fields("code")
            vName = oRs.Fields("name")
            vPrice = Format(oRs.Fields("price"), "#,##0.00")
            vCatalogId = oRs.Fields("catalogid")
            vDescription = oRs.Fields("description")
            vImageURL = oRs.Fields("imageurl")
            vPromotionCode = oRs.Fields("promotioncode")
            vPromotionEndDate = oRs.Fields("promotionenddate")
            vPublicationDate = oRs.Fields("publicationdate")
            
            CatalogItem.Add vCode, Key:="code"
            CatalogItem.Add vName, Key:="name"
            CatalogItem.Add vPrice, Key:="price"
            CatalogItem.Add vCatalogId, Key:="catalogid"
            CatalogItem.Add vDescription, Key:="description"
            CatalogItem.Add vImageURL, Key:="imageurl"
            CatalogItem.Add vPromotionCode, Key:="promotioncode"
            CatalogItem.Add vPromotionEndDate, Key:="promotionenddate"
            CatalogItem.Add vPublicationDate, Key:="publicationdate"
    
            vItems.Add CatalogItem
        
            Set CatalogItem = Nothing
            oRs.MoveNext
        Wend
            
        oRs.Close
    
    End If
     
    vResponse.Add False, Key:="error"
    vResponse.Add vItems, Key:="items"
     
    oObjectContext.SetComplete
    Set GetCatalogItemsByTypes = vResponse

    Exit Function
    
GetCatalogItemsByTypesErr:
    oObjectContext.SetAbort
    Set GetCatalogItemsByTypes = RaiseError("GetCatalogItemsByTypes")
    
End Function

'##ModelId=33EA35320032
Private Sub Class_Initialize()
End Sub

'##ModelId=33EA353201AF
Private Sub Class_Terminate()
End Sub

